var gLastMenu = 0
var gSize = 0

const SMALL_SHIP_PRICE = 50
const MEDIUM_SHIP_PRICE = 100
const BIG_SHIP_PRICE = 250

const SMALL_SHIP_REQ = 14
const MEDIUM_SHIP_REQ = 24
const BIG_SHIP_REQ = 40

function Menu_Start_Shipyard()
{
	if (!gSuspendMovement)
		{
			gDone = true;
		
			gSuspendMovement = true
		
			gMenuContainer = new menu_oContainer(0,0)
			
			gMenuContainer.on = true
			
			gMenuContainer.menus.push( new menu_oMenu(120, 240/2, STYLE_VERTICAL, "style.rws", 
																								BasicMenuUpdate, BasicMenuRender) )																				
			gMenuContainer.menus[0].AddChild( new menu_oChild_Option("Assemble Ship", Menu_Shipyard_Assemble_Start) )	
			//gMenuContainer.menus[0].AddChild( new menu_oChild_Option("Assemble Ship ("+"price"+")", NotEnoughGold) )		
			gMenuContainer.menus[0].AddChild( new menu_oChild_Option("Dismantle Ship", Menu_Shipyard_Disassemble) )
			gMenuContainer.menus[0].AddChild( new menu_oChild_Option("Leave Shop", LeaveShop) )
			
			if (gPlayer_Ship == -1) gMenuContainer.menus[0].children[1].selectable = false;
			else { gMenuContainer.menus[0].children[0].selectable = false; }										
	
			gMenuContainer.menus.push( new menu_oMenu(10, 10, STYLE_VERTICAL, "style.rws", 
																								BasicMenuUpdate, BasicMenuRender) )		
																								
			gMenuContainer.menus[1].AddChild( new menu_oChild_Text("Gold: "+gPlayer_Gold) )
			gMenuContainer.menus[1].AddChild( new menu_oChild_Text("Mushrooms: "+gPlayer_Mushrooms.length) )																											

			gMenuContainer.menus.push( new menu_oMenu(110, 106, STYLE_VERTICAL, "style.rws", 
																								BasicMenuUpdate, BasicMenuRender) )		
																								
			gMenuContainer.menus[2].AddChild( new menu_oChild_Text("Shipyard") )																					

		}
}

function Menu_Shipyard_Disassemble()
{
	//Abort(gPlayer_Mushrooms+"---"+gPlayer_Ship.mushrooms)
	var newmush = new Array()
	
	for (var i = 0; i < gPlayer_Ship.mushrooms.length; i++)
		{
			gPlayer_Mushrooms.push( Clone(gPlayer_Ship.mushrooms[i] ) )
		}
	
	//gPlayer_Mushrooms = gPlayer_Mushrooms + gPlayer_Ship.mushrooms
	gPlayer_Ship = -1 
	LeaveShop()
}

function NotEnoughMushroomsShip()
{
	gSuspendMovement = true
		
	gMenuContainer = new menu_oContainer(0,0)
			
	gMenuContainer.on = true

	gMenuContainer.menus.push( new menu_oMenu(20, 30, STYLE_VERTICAL, "style.rws", 
																	          BasicMenuUpdate, BasicMenuRender) )
																	          
	gMenuContainer.menus[gMenuContainer.menus.length-1].AddChild( new menu_oChild_Text(
	
	"Not enough mushrooms placed!") )		
	
	gMenuContainer.menus[gMenuContainer.menus.length-1].AddChild( new menu_oChild_Option("", CloseWindows) )	
													          
}

function CloseWindows()
{
	gMenuContainer.on = false
	gSuspendMovement = false
}

function MushroomsMustBeEven()
{
	gLastMenu = gMenuContainer.player_menu

	gMenuContainer.menus.push( new menu_oMenu(20, 30, STYLE_VERTICAL, "style.rws", 
																	          BasicMenuUpdate, BasicMenuRender) )
																	          
	gMenuContainer.menus[gMenuContainer.menus.length-1].AddChild( new menu_oChild_Text(
	
	"Mushrooms must be even.") )		
	
	gMenuContainer.menus[gMenuContainer.menus.length-1].AddChild( new menu_oChild_Option("", CloseLastWindow) )	
	
	gMenuContainer.player_menu = gMenuContainer.menus.length-1													          
}

function CloseLastWindow()
{
	gMenuContainer.menus.pop()
	
	gMenuContainer.player_menu = 0
	
	gMenuContainer.player_menu = gLastMenu
}

function Menu_Shipyard_Assemble_Start()
{
	gMenuContainer.menus.push( new menu_oMenu(20, 30, STYLE_VERTICAL, "style.rws", 
																	          BasicMenuUpdate, BasicMenuRender) )

	gMenuContainer.menus.push( new menu_oMenu(280, 30, STYLE_VERTICAL, "style.rws", 
																	          BasicMenuUpdate, BasicMenuRender) )																		       																	          	
																	          
	gMenuContainer.menus[3].AddChild( new menu_oChild_Text("You ") )		
	gMenuContainer.menus[4].AddChild( new menu_oChild_Text("Ship") )
	
	gMenuContainer.menus.push( new menu_oMenu(60, 30, STYLE_VERTICAL, "style.rws", 
																	          BasicMenuUpdate, BasicMenuRender) )		
	
	gMenuContainer.menus[5].AddChild( new menu_oChild_Text("Durability: ") )
	gMenuContainer.menus[5].AddChild( new menu_oChild_Text("Cannon: ") )
	gMenuContainer.menus[5].AddChild( new menu_oChild_Text("Speed: ") )
	gMenuContainer.menus[5].AddChild( new menu_oChild_Text("Accuracy: ") )
	gMenuContainer.menus[5].AddChild( new menu_oChild_Text("Value: ") )
	
	var o = false

	for (var i = 0; i < gPlayer_Mushrooms.length; i++)
		{
			o = false
			
			for (var i2 = 0; i2 < gMenuContainer.menus[3].children.length; i2++)
				{
					
					
					if (gMenuContainer.menus[3].children[i2].img == GetMushroomTypePicture(gPlayer_Mushrooms[i].type))
						{
							gMenuContainer.menus[3].children[i2].quantity++;
							//gMenuContainer.menus[4].children[i].quantity++;
							o = true
						}
				}		
				
			if (o == false)
				{
					gMenuContainer.menus[3].AddChild( new menu_oChild_SwapMushrooms(gPlayer_Mushrooms[i].type,1, SwapMushroomsA) )
					gMenuContainer.menus[4].AddChild( new menu_oChild_SwapMushrooms(gPlayer_Mushrooms[i].type,0, SwapMushroomsB) )
				}				
		}

	gMenuContainer.menus[3].AddChild( new menu_oChild_Option("Build", Menu_Shipyard_BuildShipTypeSelect) )
	gMenuContainer.menus[3].AddChild( new menu_oChild_Option("Back", Menu_Shipyard_Assemble_Back) )
			
	//gMenuContainer.menus[4].AddChild( new menu_oChild_Option("Build", Menu_Shipyard_BuildShipTypeSelect) )
	//gMenuContainer.menus[4].AddChild( new menu_oChild_Option("Back", Menu_Shipyard_Assemble_Back) )																	          
														          																	          
	gMenuContainer.player_menu = 3																          
}

function Menu_Shipyard_BuildShipTypeSelect()
{

	gMenuContainer.menus.pop()

	var total = 0

	for (var i = 0; i < gMenuContainer.menus[4].children.length; i++)
		{
			if (gMenuContainer.menus[4].children[i].quantity != undefined) total += gMenuContainer.menus[4].children[i].quantity
		}

	gMenuContainer.menus.push( new menu_oMenu(60, 90, STYLE_VERTICAL, "style.rws", 
																	          BasicMenuUpdate, BasicMenuRender) )																	          
																	          
	gMenuContainer.menus.push( new menu_oMenu(44, 76, STYLE_VERTICAL, "style.rws", 
																	          BasicMenuUpdate, BasicMenuRender) )																	          
																	          
	gMenuContainer.menus[6].AddChild( new menu_oChild_Text("Select ship type") )
	
	gMenuContainer.menus[5].AddChild( new menu_oChild_Option("Small ($"+SMALL_SHIP_PRICE+", Mushrooms: "+SMALL_SHIP_REQ+")", Menu_Shipyard_BuildSmallShip) )
	gMenuContainer.menus[5].AddChild( new menu_oChild_Option("Medium ($"+MEDIUM_SHIP_PRICE+", Mushrooms: "+MEDIUM_SHIP_REQ+")", Menu_Shipyard_BuildMediumShip) )
	gMenuContainer.menus[5].AddChild( new menu_oChild_Option("Big ($"+BIG_SHIP_PRICE+", Mushrooms: "+BIG_SHIP_REQ+")", Menu_Shipyard_BuildLargeShip) )
	gMenuContainer.menus[5].AddChild( new menu_oChild_Option("Back", Menu_Shipyard_ShipType_Back) )	
	
	if (gPlayer_Gold < SMALL_SHIP_PRICE || total < SMALL_SHIP_REQ) 
		gMenuContainer.menus[5].children[0].selectable = false;
	if (gPlayer_Gold < MEDIUM_SHIP_PRICE || total < MEDIUM_SHIP_REQ) 
		gMenuContainer.menus[5].children[1].selectable = false;
	if (gPlayer_Gold < BIG_SHIP_PRICE || total < BIG_SHIP_REQ) 
		gMenuContainer.menus[5].children[2].selectable = false;			
		
	gMenuContainer.player_menu = 5
}

function Menu_Shipyard_BuildSmallShip()
{
	var mushrooms = new Array()

	for (var i = 0; i < gMenuContainer.menus[4].children.length; i++)
		{
			if (gMenuContainer.menus[4].children[i].quantity != undefined)
				{
					for (var i2 = 0; i2 < gMenuContainer.menus[4].children[i].quantity; i2++)
						mushrooms.push( GetMushroomType(gMenuContainer.menus[4].children[i].img) )
				}
		}
		
	LeaveShop()
		
	//Abort(mushrooms)	
	
	gSuspendMovement = true
	
	gSize = 0
		
	StartItemBuild(mushrooms,"ship0.png", "ship0-2.png");	
}

function Menu_Shipyard_BuildMediumShip()
{
	var mushrooms = new Array()

	for (var i = 0; i < gMenuContainer.menus[4].children.length; i++)
		{
			if (gMenuContainer.menus[4].children[i].quantity != undefined)
				{
					for (var i2 = 0; i2 < gMenuContainer.menus[4].children[i].quantity; i2++)
						mushrooms.push( GetMushroomType(gMenuContainer.menus[4].children[i].img) )
				}
		}
		
	LeaveShop()
		
	//Abort(mushrooms)	
	
	gSuspendMovement = true
	
	gSize = 1
		
	StartItemBuild(mushrooms,"ship1.png", "ship1-2.png");	
}

function Menu_Shipyard_BuildLargeShip()
{
	var mushrooms = new Array()

	for (var i = 0; i < gMenuContainer.menus[4].children.length; i++)
		{
			if (gMenuContainer.menus[4].children[i].quantity != undefined)
				{
					for (var i2 = 0; i2 < gMenuContainer.menus[4].children[i].quantity; i2++)
						mushrooms.push( GetMushroomType(gMenuContainer.menus[4].children[i].img) )
				}
		}
		
	LeaveShop()
		
	//Abort(mushrooms)	
	
	gSuspendMovement = true
	
	gSize = 2
		
	StartItemBuild(mushrooms,"ship2.png", "ship2-2.png");	
}

function Menu_Shipyard_ShipType_Back()
{
	gMenuContainer.menus.pop()
	gMenuContainer.menus.pop()
	
	gMenuContainer.player_menu = 3
	
	gMenuContainer.menus.push( new menu_oMenu(60, 30, STYLE_VERTICAL, "style.rws", 
																	          BasicMenuUpdate, BasicMenuRender) )		
	
	gMenuContainer.menus[5].AddChild( new menu_oChild_Text("Durability: ") )
	gMenuContainer.menus[5].AddChild( new menu_oChild_Text("Cannon: ") )
	gMenuContainer.menus[5].AddChild( new menu_oChild_Text("Speed: ") )
	gMenuContainer.menus[5].AddChild( new menu_oChild_Text("Accuracy: ") )
	gMenuContainer.menus[5].AddChild( new menu_oChild_Text("Value: ") )	
}

function Menu_Shipyard_Assemble_Back()
{
	gMenuContainer.menus.pop()
	gMenuContainer.menus.pop()
	gMenuContainer.menus.pop()
	
	gMenuContainer.player_menu = 0
}

function SwapMushroomsA(parent, grandparent, greatgrandparent)
{
	if (parent.quantity > 0)
		{
			parent.quantity--;
			for (var i = 0; i < gMenuContainer.menus[4].children.length; i++)
				{
					if (gMenuContainer.menus[4].children[i].img == parent.img)
						{
							gMenuContainer.menus[4].children[i].quantity++;
						}
				}
		}
}

function SwapMushroomsB(parent, grandparent, greatgrandparent)
{
	if (parent.quantity > 0)
		{
			parent.quantity--;
			for (var i = 0; i < gMenuContainer.menus[3].children.length; i++)
				{
					if (gMenuContainer.menus[3].children[i].img == parent.img)
						{
							gMenuContainer.menus[3].children[i].quantity++;
						}
				}
		}
}

var gDone = false

function FinishShipBuild(ship_mushrooms)
{
	gDone = false

	switch (gSize)
		{
			case 0:
				if (ship_mushrooms.length < SMALL_SHIP_REQ)
					{
						NotEnoughMushroomsShip()
						return
					}
			break; case 1:
				if (ship_mushrooms.length < MEDIUM_SHIP_REQ)
					{
						NotEnoughMushroomsShip()
						return
					}				
			break; case 2:
				if (ship_mushrooms.length < BIG_SHIP_REQ)
					{
						NotEnoughMushroomsShip()
						return
					}				
			break;
		}	
	

	var mushrooms = new Array()
	
	for (var i = 0; i < ship_mushrooms.length; i++)
		{
			mushrooms[i] = Clone(ship_mushrooms[i])
		}

	switch (gSize)
		{
			case 0:
				gPlayer_Ship = new oShip("ship0-2.png", mushrooms, [])
				gPlayer_Gold -= SMALL_SHIP_PRICE
			break; case 1:
				gPlayer_Ship = new oShip("ship1-2.png", mushrooms, [])
				gPlayer_Gold -= MEDIUM_SHIP_PRICE
			break; case 2:
				gPlayer_Ship = new oShip("ship2-2.png", mushrooms, [])
				gPlayer_Gold -= BIG_SHIP_PRICE
			break;
		}
		
	for (var i = 0; i < ship_mushrooms.length; i++)
		{
			for (var i2 = 0; i2 < gPlayer_Mushrooms.length; i2++)
				{
					if (gPlayer_Mushrooms[i2].type == ship_mushrooms[i].type)
						{
							gPlayer_Mushrooms.splice(i2,1);
							i2 = gPlayer_Mushrooms.length+5
						}
				}
		}
		
	gPlayer_Ship.RegenerateShipData()
	
	gPlayer_Ship.blitSelf(0,0,.5)
	
	
		
	gSuspendMovement = true
		
	gMenuContainer = new menu_oContainer(0,0)
			
	gMenuContainer.on = true
			
	gMenuContainer.menus.push( new menu_oMenu(150, 70, STYLE_VERTICAL, "style.rws", 
														BasicMenuUpdate, BasicMenuRender) )	
														
	gMenuContainer.menus.push( new menu_oMenu(120, 10, STYLE_VERTICAL, "style.rws", 
														BasicMenuUpdate, BasicMenuRender) )		
														
	gMenuContainer.menus.push( new menu_oMenu(20, 100, STYLE_VERTICAL, "style.rws", 
														BasicMenuUpdate, BasicMenuRender) )		
														
	gMenuContainer.menus.push( new menu_oMenu(135, 220, STYLE_VERTICAL, "style.rws", 
														BasicMenuUpdate, BasicMenuRender) )																
																																													
			
	gMenuContainer.menus[2].AddChild( new menu_oChild_Text("Cannon: "+gPlayer_Ship.stats.cannon) )
	gMenuContainer.menus[2].AddChild( new menu_oChild_Text("Hull: "+gPlayer_Ship.stats.hp) )	
	gMenuContainer.menus[2].AddChild( new menu_oChild_Text("Speed: "+gPlayer_Ship.stats.speed) )	
	gMenuContainer.menus[2].AddChild( new menu_oChild_Text("Accuracy: "+gPlayer_Ship.stats.accuracy) )	
	gMenuContainer.menus[2].AddChild( new menu_oChild_Text("Value: "+gPlayer_Ship.stats.value) )	
														
							
	gMenuContainer.menus[1].AddChild( new menu_oChild_Text("Ship built!") )							
														
	gMenuContainer.menus[3].AddChild( new menu_oChild_Option("Done", CloseWindows) )													
	gMenuContainer.menus[0].AddChild( new menu_oChild_Image( gPlayer_Ship.image_cache[.5] ) )		
	
	gMenuContainer.player_menu = 3											
	
}

function LeaveShop()
{
	gMenuContainer.on = false
	
	n = GetPlayer()
	
	gPeople[n].move = 1
	
	while (gPeople[n].move != -1)
		{
			RenderMap()
			RenderProcess_Manager_Run()
			UpdateProcess_Manager_Run()
			
			FlipScreen()
		}
	
	gSuspendMovement = false;
}